#ifndef DEBUG_H
#define DEBUG_H

#include <Alert.h>
#include <OS.h>
#include "PortMessage.h"

#define		DEBUG_CHECK			0
#define		DEBUG_DEBUG_MSG		1

////////////////////////////////////////////////////////////////
// Debug server calls
////////////////////////////////////////////////////////////////

void Debug(const char *s=NULL, const char *s=NULL);
void Debug(char c, const char *s=NULL, const char *s=NULL);

// Check if there have been 'e' (error) class debug output messages since
// last call to CheckDebug. Gives an Alert box if there have been.
void CheckDebug();

/////////////////////////////////////////////////////////////////
// GUI debugging
/////////////////////////////////////////////////////////////////

// Send debugging message to the maze GUI. Puts up a dialog box for the user
// to see. Don't use many of these. Don't want error dialogs cluttering the
// user's screen.
void DebugGUI(const char *s);

//////////////////////////////////////////////////////////////////
// Primitive Internal Debugging (makes no use of GUI or ports or threads).
// For use in lower level parts of system or when starting the system.
//////////////////////////////////////////////////////////////////

// Just sends a message to the debug window
void DebugBoot(const char *s);
void DebugBoot(char errorType, const char *s=NULL, const char *s=NULL);

class DebugServer {
	public:
		DebugServer();
		~DebugServer();
		
		void SendMessage(BMessage *msg); // send the debug server a message
		
	private:// function members
		void DebugMsg(char c, const char *s=NULL, const char *s=NULL);
		void CheckDebug();
		friend long Dispatch(void *);
		
	private: // data members
		PortMessage *port;
		int numErrors;
		thread_id debugThreadID;
};

// Internal debug.cpp use
void SendDebugMonitor(char errorType, const char *m1=NULL, const char *m2=NULL);

#endif DEBUG_H